"use client";

import { Category } from "@/types/category";
import Link from "next/link";
import ImageComp from "../Shared/Image";
import { usePathname } from 'next/navigation';
import { useState, useEffect } from 'react';
import { getCategoryType } from "@/lib/storage";

interface categoriesProps {
  categories: Category[];
}

export default function CategoriesSidebar({ categories }: categoriesProps) {
    const pathname = usePathname();
    const [activeCategory, setActiveCategory] = useState<string | null>(null);
    const [categoryType, setCategoryType] = useState<string | null>(null); 

    useEffect(() => {
        // Set the active category and subcategory based on the pathname
        const pathParts = pathname.split('/');
        const categoryTypee = pathParts[1] ?? getCategoryType();
        const categorySlug = pathParts[3];
        const subCategorySlug = pathParts[4];
        
        // Set active category if available
        if (categorySlug) {
            setActiveCategory(categorySlug);
        }

        if (categoryTypee) {
            setCategoryType(categoryTypee);
        }


        // Optional: If you need to set collapse state based on subcategory slug, handle it accordingly
    }, [pathname]);

    const handleCategoryClick = (category: string) => {
        window.location.href = `/${categoryType}/products/${category}`;
    };
    
    const handleSubCategoryClick = (category: string, subCategory: string) => {
        window.location.href = `/${categoryType}/products/${category}/${subCategory}`;
    };

    // Helper function to check if the link is active
    const isActiveLink = (path: string) => {
        return pathname === path;
    };

    return (
        <>
            <div className="listing-sidebar">
                <div className="sidebar-title">
                    <div className="icon-pl">
                        <ImageComp src="/images/sidebar-pl.webp" alt="sidebar-pl" width={15} height={23} />
                    </div>
                    <span>Categories</span>
                </div>
                {categories.length === 0 ? (
                    <p>No categories available.</p>
                ) : (
                    <ul className="sidebar-list">
                        {categories.map((cat) => (
                            <li className="sidebar-list-item" key={cat.id}>
                                {cat.sub_categories.length > 0 ? (
                                    <>
                                        <Link
                                            className={`siderbar-list-link ${(isActiveLink(`/${categoryType}/products/${cat.slug}`) || activeCategory === cat.slug) ? 'active' : ''}`}
                                            data-bs-toggle="collapse"
                                            href={`#collapseCategory${cat.id}`}
                                            role="button"
                                            aria-expanded={activeCategory === cat.slug ? 'true' : 'false'}
                                            aria-controls={`collapseCategory${cat.id}`}
                                        >
                                            {cat.title ?? ''}
                                        </Link>
                                        <div
                                            className={`collapse ${activeCategory === cat.slug ? 'show' : ''}`}
                                            id={`collapseCategory${cat.id}`}
                                        >
                                            <ul className="sidebar-list-inner">
                                                {cat.sub_categories.map((subcat) => (
                                                    <li className="inner-list-item" key={subcat.id}>
                                                        <Link
                                                            className={`inner-list-link ${isActiveLink(`/${categoryType}/products/${cat.slug}/${subcat.slug}`) ? 'active' : ''}`}
                                                            href={`/${categoryType}/products/${cat.slug}/${subcat.slug}`}
                                                            onClick={() => handleSubCategoryClick(cat.slug, subcat.slug)}
                                                        >
                                                            {subcat.title ?? ''}
                                                        </Link>
                                                    </li>
                                                ))}
                                            </ul>
                                        </div>
                                    </>
                                ) : (
                                    <Link
                                        className={`siderbar-list-link ${isActiveLink(`/products/${cat.slug}`) ? 'active' : ''}`}
                                        href={`${categoryType}/products/${cat.slug}`}
                                        onClick={() => handleCategoryClick(cat.slug)}
                                    >
                                        {cat.title}
                                    </Link>
                                )}
                            </li>
                        ))}
                    </ul>
                )}
            </div>
        </>
    );
}
