

"use client";

interface Advantage {
    id: number;
    advantage: string;
}

interface AdvantagesProps {
    advantages: Advantage[];
}

export default function Advantages({ advantages } : AdvantagesProps){
    return (
        <>
            <div className="advantages-block">
                <h6 className="title-pd">
                    Advantages
                </h6>
                {advantages.length === 0 ? (
                    <p>No Advantages.</p>
                ) : (
                    <ul className="advantages-list">
                        {advantages.map((advantage) => (
                            <li className="advantages-item" key={`adv-${advantage.id}`}>
                                {advantage.advantage}
                            </li>
                        ))}
                    </ul>
                )}
            </div>
        </>
    );
}

