

"use client";

interface Application {
    id: number;
    key: string;
    value: string;
}

interface ApplicationsProps {
    applications: Application[];
}

export default function Applications({ applications } : ApplicationsProps){
    return (
        <>
            
            <div className="advantages-block">
                <h6 className="title-pd">
                Application
                </h6>
                {applications.length === 0 ? (
                    <p>No Applications.</p>
                ) : (
                    <ul className="advantages-list">
                        {applications.map((application) => (
                            <li className="advantages-item d-flex" key={`adv-${application.id}`}>
                                <p className="me-2 mb-0">{ application.key ?? "" }:</p>
                                <span>{ application.value ?? "" }</span>
                            </li>
                        ))}
                    </ul>
                )}
            </div>
        </>
    );
}

