

"use client";

interface Specification {
    id: number;
    key: string;
    value: string;
}

interface SpecificationsProps {
    specifications: Specification[];
}

export default function Specifications({ specifications } : SpecificationsProps){
    return (
        <>            
            <div className="application-item">
                <h6 className="title-pd">
                Specifications
                </h6>
                {specifications.length === 0 ? (
                    <p>No Specifications.</p>
                ) : (
                    <div className="inner-box">
                        {specifications.map((specification) => (
                            <div className="application-list" key={`adv-${specification.id}`}>
                                <span>{specification.key ?? ""}</span>
                                <strong>{specification.value ?? ""}</strong>
                            </div>
                        ))}
                    </div>
                )}
            </div>
        </>
    );
}

