"use client";

import { useEffect, useState } from "react";
import ProductSlider from "@/components/Products/ProductsSlider";
import { Product } from "@/types/product";
import ProductImage from "./ProductImage";
import ProductDescription from "./ProductDescription";
import Advantages from "./Details/Advantages";
import Applications from "./Details/Applications";
import Specifications from "./Details/Specifications";
import Composition from "./Details/Composition";
import Crops from "./Details/Crops";
import { getCategoryType } from "@/lib/storage";

interface Subcategory {
    id: number;
    title: string;
    slug: string;
    description: string;
    products:Product[];
}

interface ProductDetailsProps {
    category : string;
    subCategory : string;
    productSlug : string;
    product: Product | null;
    
}

export default function ProductDetailsComponent({ category, subCategory, productSlug, product }: ProductDetailsProps) {
    const [categoryType, setCategoryType] = useState<string>('');
    
    useEffect(() => {
        const categoryTypee = getCategoryType();
        if(categoryTypee){
            setCategoryType(categoryTypee);
        }
    });
    
  return (
    <>
    {product && (
        <section className="product-details-wrapper py-120">
            <div className="md-container">
                <div className="row">
                    <div className="col-12 col-sm-5 col-md-4 col-lg-4">
                        <div className="detail-sidebar">
                            <div className="product-img">
                                <ProductImage image_path={product.uploads[0]?.file_path} title={product.title ?? 'product image'} width={176} height={346} />
                            </div>
                        </div>
                    </div>
                    <div className="col-12 col-sm-7 col-md-8 col-lg-8">
                        <div className="product-detail-content">
                            <div className="title">
                                <h2>{product.title ?? "" }</h2>
                            </div>
                            
                            <ProductDescription html={product?.short_description} />
                            <ProductDescription html={product.description} />
                                                
                        </div>
                    </div>
                    <div className="col-12">
                        <div className="row gap-80 top-80">
                            <div className="col-12 col-md-6">
                                <Advantages advantages={product.advantages} />
                            </div>

                            <div className="col-12 col-md-6">
                                <Applications applications={product.applications} />
                            </div>
                            
                            <div className="col-12 col-md-6">
                                <div className="application-grid">
                                    <Specifications specifications={product.specifications} />
                                </div>
                            </div>
                            
                            <div className="col-12 col-md-6">
                                <Composition compositions={product.compositions} />
                            </div>

                            <div className="col-12">
                                <Crops crops={product.crops} />
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
    )}

    <section className="our-product-slide py-120 pt-0">
        <ProductSlider categoryType={categoryType} products={product?.Subcategory?.products ?? []} subcategorySlug={product?.Subcategory?.slug ?? null} categorySlug={product?.Subcategory?.Category?.slug ?? null} />
    </section>
    </>

  );
}
