"use client";

import { useEffect, useState } from "react";
import CategoriesSidebar from "@/components/Products/Categories-aside";
import ImageComp from "../Shared/Image";
import Link from "next/link";
import ProductImage from "@/components/Products/ProductImage";
import ProductDescription from "@/components/Products/ProductDescription";
import ViewButton from "@/components/Products/ViewButton";
import { Category } from "@/types/category";
import { Product } from "@/types/product";
import { getCategoryType } from "@/lib/storage";
import { fetchProducts } from "@/lib/apis/products";

interface ProductListingProps {
    products: Product[];
    categories: Category[];
    totalProducts: number;
}

export default function ProductListing({ category, subCategory, industry, categories }: any) {
    const [categoryType, setCategoryType] = useState<string>('');
    const [currentPage, setCurrentPage]= useState<any>(1);
    const [products, setProducts]= useState<any>([]);
    const [totalPage, setTotalPage]= useState<any>([]);
    const [totalProducts, setTotalProducts]= useState<any>([]);
    const [showLoader, setShowLoader] = useState(true);

    useEffect(() => {
        const categoryTypee = getCategoryType();
        if(categoryTypee){
            setCategoryType(categoryTypee);
        }
        getMoreProduct();
    },[]);

    const getMoreProduct = async () =>{
        setShowLoader(true);
        setCurrentPage(currentPage + 1);
        let fetchedProducts: any = null;
        if(subCategory){
            fetchedProducts = await fetchProducts(currentPage, 20, industry, category, subCategory);      
        }else if(category){
            fetchedProducts = await fetchProducts(currentPage, 20, industry, category);
        }else if(industry){
            fetchedProducts = await fetchProducts(currentPage, 20,industry);
        }else{
            fetchedProducts = await fetchProducts(currentPage, 20);
        }
        setShowLoader(false);
        let productListGet = fetchedProducts.products;
        setTotalPage(fetchedProducts?.pagination?.totalPages || 0)
        setProducts((prev: any) => {
        const allProducts = [...prev, ...productListGet];
        const uniqueProducts = Array.from(
            new Map(allProducts.map((product) => [product.id, product])).values()
        );
        return uniqueProducts;
        });
        let getTotalProduct = fetchedProducts.pagination?.totalItems || 0;
        setTotalProducts(getTotalProduct);
    } 


    return (
        <>        
            <section className="product-listing-wrapper py-120">
                <div className="container">
                    <div className="row">
                        <div className="col-12 col-md-4 col-lg-3">
                            <CategoriesSidebar categories={categories} /> 
                        </div>
                        <div className="col-12 col-md-8 col-lg-9">
                            <div className="product-list">
                                <div className="product-list-count">
                                    <span>
                                        {totalProducts} Product(s) listed 
                                        {showLoader && 
                                           <span className="spinner-border text-info product-loader-spinner" role="status">
                                                <span className="visually-hidden">Loading...</span>
                                            </span>
                                         } 
                                    </span>
                                </div>
                                <div className="product-list-inner">
                                    {products.length === 0 ? (
                                         !showLoader &&
                                         <div className="no-product-available">
                                            <img src='/images/no_products.png' alt="about-ani01" />
                                         <p className="products-dec-text text-center comingsoon-text">No products available.</p>                                         
                                         </div>
                                    ) : (
                                        <ul className="product-list-pl">
                                            {products?.map((prod:any, index:any) => (
                                                <li className="product-list-item-pl" key={index}>
                                                     <Link href={`/${categoryType}/products/${prod.subCategory.category.slug}/${prod.subCategory.slug}/${prod.slug}`} className="">
                                                    <div className="product-list-box">
                                                        <div className="product-list-img">
                                                            <ProductImage image_path={prod.productUploads[0]?.file_path} title={prod.title ?? 'product image'} width={176} height={346} />
                                                        </div>
                                                        <div className="product-list-content">
                                                            <h4>{prod.title ?? ''}</h4>

                                                            <ProductDescription html={prod?.short_description} />

                                                            {/* <ViewButton id={prod.id} categoryType={categoryType} subcategory={prod.subCategory.slug} category={prod.subCategory.category.slug} slug={prod.slug} /> */}

                                                             <span className="view-btn">
                                                                View
                                                                <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <g clipPath="url(#clip0_464_841)">
                                                                    <path d="M8.78125 2.78876L14.2812 8.03876C14.4271 8.18459 14.5 8.36167 14.5 8.57001C14.5 8.77834 14.4271 8.95542 14.2812 9.10126L8.78125 14.3513C8.40625 14.6429 8.05208 14.6429 7.71875 14.3513C7.42708 13.9763 7.42708 13.6221 7.71875 13.2888L11.875 9.32001H1.25C0.791667 9.27834 0.541667 9.02834 0.5 8.57001C0.541667 8.11167 0.791667 7.86167 1.25 7.82001H11.875L7.71875 3.85126C7.42708 3.51792 7.42708 3.16376 7.71875 2.78876C8.05208 2.49709 8.40625 2.49709 8.78125 2.78876Z" fill="currentcolor"/>
                                                                    </g>
                                                                    <defs>
                                                                    <clipPath id="clip0_464_841">
                                                                    <rect width="14" height="16" fill="white" transform="matrix(1 0 0 -1 0.5 16.57)"/>
                                                                    </clipPath>
                                                                    </defs>
                                                                </svg>                                                    
                                                            </span>
                                                        </div>
                                                    </div>
                                                    </Link>
                                                </li>
                                            ))}
                                        </ul>
                                    )}
                                    {(products.length > 1 && (currentPage - 1) < totalPage)  && (
                                    <div className="loard-more-btn">
                                        <button className="btnprimary" onClick={()=>getMoreProduct()}>
                                            Load More 
                                        </button>
                                    </div>
                                    )}
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div className="ourproduct-shap">
                    <ImageComp src="/images/ourproduct-shap-list.webp" height={162} width={130} alt="ourproduct-shap-list" />
                </div>
            </section>
        </>
    );
}