'use client';

import { useEffect, useState } from "react";
import { Product } from "@/types/product";
import { fetchProducts } from "@/lib/apis/products";

interface LoadMoreProps {
  initialProducts: Product[];
  limit?: number;
}

export default function LoadMoreButton({ initialProducts, limit = 6 }: LoadMoreProps) {
  const [products, setProducts] = useState<Product[]>(initialProducts);
  const [page, setPage] = useState(1);
  const [loading, setLoading] = useState(false);

  const handleLoadMore = async () => {
    setLoading(true);
    try {
      const nextPage = page + 1;
      const { products, pagination } = await fetchProducts(nextPage, limit);
      setProducts((prev) => [...prev, ...products]);
      setPage(nextPage);
    } catch (error) {
      console.error("Error loading more:", error);
    } finally {
      setLoading(false);
    }
  };

  return (
    <>
        {products.length > 0 && (
        <ul className="product-list-pl">
            {products.map((product) => (
            <li key={product.id}>{product.title}</li>
            ))}
        </ul>
        )}

        <div className="text-center">
        <button
            onClick={handleLoadMore}
            className="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700"
            disabled={loading}
        >
            {loading ? "Loading..." : "Load More"}
        </button>
        </div>
    </>
  );
};

