"use client";

import { useEffect, useState, useRef, ReactNode } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';
import SwiperSlider from '../Products/SwiperSlider';
import ProductImage from '../Products/ProductImage';
import ProductDescription from '../Products/ProductDescription';
import ViewButton from './ViewButton';
import { Product } from '@/types/product';
import { getCategoryType } from '@/lib/storage';

interface ProductSliderProps {
    categoryType:string | null;
    subcategorySlug:string | null;
    categorySlug:string | null ;
    products:Product[] | null;
    isHomePage?: boolean;
}

export default function ProductSlider({ products, subcategorySlug, categorySlug, isHomePage = false } : ProductSliderProps){    
    const validProducts = products?.length ? products : [];

    const [categoryType, setCategoryType] = useState<string>('');
        
    useEffect(() => {
        const categoryTypee = getCategoryType();
        if(categoryTypee){
            setCategoryType(categoryTypee);
        }
    });
    
    const slides = validProducts.map((product) => {
        const {
            id,
            title,
            slug,
            description,
            short_description,
            uploads,
            productUploads,
            subCategory
        } = product;

        return (
            <div key={id} className="product-list-box">
                <div className="product-list-img">
                    <ProductImage
                        image_path={uploads?.[0]?.file_path || productUploads?.[0]?.file_path}
                        title={title ?? 'product image'}
                        width={120}
                        height={106}
                    />
                </div>
                <div className="product-list-content">
                    <h4>{title}</h4>
                    <ProductDescription html={short_description} />
                    <ViewButton
                        id={id}
                        categoryType={categoryType}
                        subcategory={subcategorySlug || subCategory?.slug || ''}
                        category={categorySlug || subCategory?.category?.slug || ''}
                        slug={slug}
                    />
                </div>
            </div>
        );
    });

    return (
        <>    
            <div className="md-container">
                <div className="row">
                     {
                        !isHomePage  && (
                            <div className="col-12 col-md-4 col-lg-4">
                                <div className="product-slide-left">
                                    <h2 className="dim-text">
                                            Other Products
                                    </h2> 
                                </div>                          
                                    {slides.length > 3 && (
                                        <div className="productslider-slidearrows">
                                            <div className="productslider-left-arrow">
                                                <svg width="21" height="24" viewBox="0 0 21 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M8.57812 3.32812L0.328125 11.2031C0.109375 11.4219 0 11.6875 0 12C0 12.3125 0.109375 12.5781 0.328125 12.7969L8.57812 20.6719C9.14062 21.1094 9.67188 21.1094 10.1719 20.6719C10.6094 20.1094 10.6094 19.5781 10.1719 19.0781L3.9375 13.125H19.875C20.5625 13.0625 20.9375 12.6875 21 12C20.9375 11.3125 20.5625 10.9375 19.875 10.875H3.9375L10.1719 4.92188C10.6094 4.42188 10.6094 3.89062 10.1719 3.32812C9.67188 2.89062 9.14062 2.89062 8.57812 3.32812Z" fill="currentcolor"/>
                                                </svg>                                   
                                            </div>
                                            <div className="productslider-right-arrow">
                                                <svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12.4219 0.328125L20.6719 8.20312C20.8906 8.42188 21 8.6875 21 9C21 9.3125 20.8906 9.57812 20.6719 9.79688L12.4219 17.6719C11.8594 18.1094 11.3281 18.1094 10.8281 17.6719C10.3906 17.1094 10.3906 16.5781 10.8281 16.0781L17.0625 10.125H1.125C0.4375 10.0625 0.0625 9.6875 0 9C0.0625 8.3125 0.4375 7.9375 1.125 7.875H17.0625L10.8281 1.92188C10.3906 1.42188 10.3906 0.890625 10.8281 0.328125C11.3281 -0.109375 11.8594 -0.109375 12.4219 0.328125Z" fill="currentcolor"/>
                                                </svg>  
                                            </div>
                                        </div>
                                        )}
                            </div>                        
                        )
                    }
                    <div className={`col-12  ${isHomePage?'col-md-12 col-lg-12':'col-md-8 col-lg-8'}`}>
                        {slides.length === 0 ? (
                            <p>No products available.</p>
                        ) : (
                            <SwiperSlider
                                modules = {[Navigation]}
                                navigation={{
                                    nextEl: ".productslider-right-arrow",
                                    prevEl: ".productslider-left-arrow",
                                }}
                                slidesPerView={isHomePage?4:3}
                                className="product-slide"
                                grabCursor={true}
                                slides={slides}
                                effectName="cards"
                                cardsEffect={{
                                    perSlideOffset: 20,
                                    perSlideRotate: 0,
                                    slideShadows: false
                                }}
                                section_name='product-details'
                                breakpoints={{
                                    0: {
                                        slidesPerView: 1,
                                    },
                                    600: {
                                        slidesPerView: 2,
                                        spaceBetween: 20,
                                    },
                                    1300: {
                                        slidesPerView: isHomePage?4:3,
                                        spaceBetween: 20,
                                    },
                                    1600: {
                                        slidesPerView: isHomePage?4:3,
                                        spaceBetween: 30,
                                    },
                                }} 
                            />
                        )}
                        
                    </div>

                    {
                        isHomePage  && (
                            <div className="col-12 col-md-12 col-lg-12">                         
                                {slides.length > 4 && (
                                    <div className="productslider-slidearrows">
                                        <div className="productslider-left-arrow">
                                            <svg width="21" height="24" viewBox="0 0 21 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.57812 3.32812L0.328125 11.2031C0.109375 11.4219 0 11.6875 0 12C0 12.3125 0.109375 12.5781 0.328125 12.7969L8.57812 20.6719C9.14062 21.1094 9.67188 21.1094 10.1719 20.6719C10.6094 20.1094 10.6094 19.5781 10.1719 19.0781L3.9375 13.125H19.875C20.5625 13.0625 20.9375 12.6875 21 12C20.9375 11.3125 20.5625 10.9375 19.875 10.875H3.9375L10.1719 4.92188C10.6094 4.42188 10.6094 3.89062 10.1719 3.32812C9.67188 2.89062 9.14062 2.89062 8.57812 3.32812Z" fill="currentcolor"/>
                                            </svg>                                   
                                        </div>
                                        <div className="productslider-right-arrow">
                                            <svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.4219 0.328125L20.6719 8.20312C20.8906 8.42188 21 8.6875 21 9C21 9.3125 20.8906 9.57812 20.6719 9.79688L12.4219 17.6719C11.8594 18.1094 11.3281 18.1094 10.8281 17.6719C10.3906 17.1094 10.3906 16.5781 10.8281 16.0781L17.0625 10.125H1.125C0.4375 10.0625 0.0625 9.6875 0 9C0.0625 8.3125 0.4375 7.9375 1.125 7.875H17.0625L10.8281 1.92188C10.3906 1.42188 10.3906 0.890625 10.8281 0.328125C11.3281 -0.109375 11.8594 -0.109375 12.4219 0.328125Z" fill="currentcolor"/>
                                            </svg>  
                                        </div>
                                </div>
                                )}
                            </div>                        
                        )
                    }


                </div>
            </div>
        </>
    );
}