"use client";

import Image from "next/image";

type ImageProps = {
    src: string;
    alt: string;
    width?: number;
    height?: number;
    section?: string;
    className?: string;
    priority?: boolean;
    styleAuto?: boolean;
  };
  
const ImageComp = ({ src, alt, width, height, section, className, priority=false, styleAuto=true }: ImageProps) => {
  
    const styles =
    styleAuto 
      ? { width: 'auto', height: 'auto' }
      : {};

    return (
      <Image src={src} alt={alt ?? 'Image'} width={width} height={height} className={className} style={styles} priority={priority} />
    );
};
  
export default ImageComp;