import { CategoryType } from "@/types/categoryType";

interface ApiResponse {
  status: boolean;
  message: string;
  data: {
    data: CategoryType[];
    pagination: {
      totalItems: number;
      totalPages: number;
      currentPage: number;
      pageSize: number;
    };
  };
}

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3000/api/v1';


export async function fetchCategoryTypes(): Promise<CategoryType[]> {
    try {   
    //   const res = await fetch(`${API_BASE_URL}/categories`);
      const res = await fetch(`${API_BASE_URL}/categories-type`);

      if (!res.ok) {
          throw new Error('Failed to fetch categories');
      }

      const result: ApiResponse = await res.json();
      return result.data.data; 
    } catch (error) {
      console.error('categories fetch error:', error);
      return [];
    }
}
