import { Setting } from "@/types/setting";

interface ApiResponse {
  status: boolean;
  message: string;
  data: {
    data: Setting[];
  };
}

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3000/api/v1';


export async function fetchSettings(): Promise<Setting[]> {
    try {      
      const res = await fetch(`${API_BASE_URL}/settings`);

      if (!res.ok) {
          throw new Error('Failed to fetch settings');
      }

      const result: ApiResponse = await res.json();
      return result.data.data; 
    } catch (error) {
      console.error('settings fetch error:', error);
      return [];
    }
}
