import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  typescript: {
    ignoreBuildErrors: true,
  },
  images: {
    remotePatterns: [],
    unoptimized: true, // For SVG files
  },
  // Enable static exports for better performance
  output: 'standalone',
};

export default nextConfig;
