-- Add onboard fields to Profile table
-- This extends the existing Profile model to store onboard data

-- Add new columns to Profile table
ALTER TABLE Profile ADD COLUMN companyName VARCHAR(255) NULL;
ALTER TABLE Profile ADD COLUMN currency VARCHAR(10) NULL DEFAULT 'EUR';
ALTER TABLE Profile ADD COLUMN dateOfBirth DATE NULL;

-- Add index for performance
CREATE INDEX idx_profile_company_name ON Profile(companyName);

-- Update existing profiles with default currency based on country
UPDATE Profile SET currency = 'CHF' WHERE countryId = 'switzerland';
UPDATE Profile SET currency = 'EUR' WHERE countryId IN ('luxembourg', 'belgium', 'france', 'italy', 'germany', 'austria', 'spain', 'portugal');
UPDATE Profile SET currency = 'GBP' WHERE countryId = 'uk';