# Database Diagnostic and Fix Scripts

This directory contains scripts to diagnose and fix user profile issues that might affect session display names.

## Available Scripts

### 1. `check-users-profiles.js`
**Purpose**: Comprehensive diagnostic script to check database for users and their profile status.

**Usage**:
```bash
node scripts/check-users-profiles.js
```

**What it checks**:
- Total users vs users with profiles
- Users without profiles (would show email-based names in sessions)
- Users with incomplete profiles (missing firstName/lastName)
- Session display name analysis
- Sample user data for debugging

**Output**: Detailed report with statistics, issues, and recommendations

---

### 2. `create-missing-profiles.js`
**Purpose**: Creates profiles for users who don't have one.

**Usage**:
```bash
# Dry run (see what would be created)
node scripts/create-missing-profiles.js --dry-run

# Actually create profiles
node scripts/create-missing-profiles.js
```

**What it does**:
- Finds users without profiles
- Creates basic profiles with names derived from email addresses
- Sets default country to Luxembourg (LU)

---

### 3. `fix-session-names.js`
**Purpose**: Comprehensive fix for all session name related issues.

**Usage**:
```bash
# Dry run (see what would be fixed)
node scripts/fix-session-names.js --dry-run

# Apply fixes
node scripts/fix-session-names.js
```

**What it fixes**:
1. **Users without profiles**: Creates profiles with names from email
2. **Profiles without names**: Adds firstName/lastName from email
3. **Partial names**: Completes missing firstName or lastName
4. **Provides summary**: Shows before/after status

---

## API Endpoint

### `/api/diagnostic/users`
**Purpose**: Web-based diagnostic endpoint for checking user profile status.

**Usage**:
```bash
# Full diagnostic report
curl http://localhost:3000/api/diagnostic/users

# Just statistics
curl http://localhost:3000/api/diagnostic/users | jq '.statistics'

# Session name analysis
curl http://localhost:3000/api/diagnostic/users | jq '.sessionNameAnalysis'

# Issues found
curl http://localhost:3000/api/diagnostic/users | jq '.issues'
```

**Response includes**:
- User statistics
- Session name analysis
- Issues and recommendations
- Sample user data
- Incomplete profile details

---

## Common Issues and Solutions

### Issue: Users showing email-based names in sessions
**Cause**: Users don't have profiles or profiles lack firstName/lastName
**Solution**: Run `fix-session-names.js`

### Issue: New users not getting proper display names
**Cause**: Profile creation might be failing during signup
**Solution**: Check signup flow and ensure profile is created with user

### Issue: Session names not updating after profile changes
**Cause**: Session data might be cached
**Solution**: User needs to log out and log back in

---

## How Session Names Work

The session display name is determined by this priority:
1. **Profile name**: `${firstName} ${lastName}`.trim()
2. **Email fallback**: `email.split('@')[0]`
3. **Default**: 'User'

This logic is implemented in `/src/app/api/profile/route.ts` line 38-40.

---

## Running the Scripts

1. **Prerequisites**: Make sure your database is running and accessible
2. **Environment**: Ensure `.env.local` has the correct `DATABASE_URL`
3. **Dependencies**: Scripts use Prisma Client directly

```bash
# Check current status
node scripts/check-users-profiles.js

# Fix any issues found
node scripts/fix-session-names.js

# Verify fixes
node scripts/check-users-profiles.js
```

---

## Integration with Application

These scripts can be:
- Run manually for troubleshooting
- Integrated into deployment scripts
- Used for data migration
- Called from admin interfaces

For production use, consider:
- Adding proper error handling
- Logging to files
- Running as scheduled jobs
- Adding user notifications