'use client';

import Link from 'next/link';

import { getCountryDataByDomain } from '@/lib/countries';

interface FooterProps {
  locale: string;
}

export default function Footer({ locale }: FooterProps) {

  const datacounter =    getCountryDataByDomain();

  return (
    <footer className="footer-wrapper">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="footer-head">
              <div className="footer-logo">
                <a href="home.html">
                  <img src="/assets/image/logo.png" alt="logo" />
                </a>
              </div>
              <div className="footer-land d-flex">
                <div className="language-selector">
                  <div className="nav-item dropdown language-dropdown">                   
                    <a href="javascript:void();" className="nav-link select-lang">
                      <img src={datacounter?.id === "uk"
                            ? "/assets/image/eng.svg"
                            : "/assets/image/french.svg"} alt="English" className="me-2" />
                            {datacounter?.id === "uk"
                            ? "EN"
                            : "FR"}
                             
                    </a>
                    <ul>

                      {datacounter?.id == "switzerland" && 
                      (
                        <>
                         <li>
                          <a className="active" href="javascript:void();">
                            <img src="/assets/image/french.svg" alt="French" className="me-2" />French
                          </a>
                        </li>
                         <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/germany.svg" alt="Germany" className="me-2" />Germany
                        </a>
                       </li>
                        <li>
                          <a className="" href="javascript:void();">
                            <img src="/assets/image/italian.svg" alt="Italian" className="me-2" />Italian
                          </a>
                        </li>
                       
                        </>
                      )                      
                      }

                      {datacounter?.id == "france" && 
                      (
                        <>
                         <li>
                          <a className="active" href="javascript:void();">
                            <img src="/assets/image/french.svg" alt="French" className="me-2" />French
                          </a>
                        </li>
                        <li>
                          <a className="" href="javascript:void();">
                            <img src="/assets/image/eng.svg" alt="English" className="me-2" />English
                          </a>
                        </li>
                        
                        </>
                      )                      
                      }

                      {datacounter?.id == "uk" && 
                      (
                        <>
                        <li>
                          <a className="active" href="javascript:void();">
                            <img src="/assets/image/eng.svg" alt="English" className="me-2" />English
                          </a>
                        </li>
                        </>
                      )                      
                      }

                      {/* <li>
                        <a className="active" href="javascript:void();">
                          <img src="/assets/image/eng.svg" alt="English" className="me-2" />English
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/italian.svg" alt="Italian" className="me-2" />Italian
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/french.svg" alt="French" className="me-2" />French
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/germany.svg" alt="German" className="me-2" />German
                        </a>
                      </li> */}

                    </ul>

                  </div>
                </div>
                <div className="footer-socail">
                  <ul>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/f-facebook.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/f-google.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/twitter.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/linkdin.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/instagram.svg" alt="" />
                      </a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-12 col-md-4">
            <div className="footer-content">
              <p>
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
              </p>
            </div>
          </div>
          <div className="col-12 col-md-8">
            <div className="footer-linking mt-4 mt-md-0">
              <div className="row row-gap-3">
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      Recruiter
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href="javascript:void(0)">
                          Getting started
                        </a>
                      </li>
                      <li>
                        <a href="javascript:void(0)">
                          How it Works
                        </a>
                      </li>
                      <li>
                        <a href="category.html">
                          Categories
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      About
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href="/about-us">
                          About Us
                        </a>
                      </li>
                      <li>
                        <a href="/contact-us">
                          Contact Us
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      Freelancer
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href="find-project.html">
                          Projects
                        </a>
                      </li>
                      <li>
                        <a href="javascript:void(0)">
                          Freelancers
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      Terms
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href="/privacy-policy">
                          Privacy Policy
                        </a>
                      </li>
                      <li>
                        <a href="/terms-condition">
                          Terms and Conditions
                        </a>
                      </li>
                      <li>
                        <a href="/faq">
                          Faqs
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="footer-copy-right">
        <p>
          Smile24@ 2025. All Rights Reserved.
        </p>
      </div>
    </footer>
  );
}
