import Image from 'next/image';

export default function BenefitsSection() {
  return (
    <section className="benefits-wrapper pt-120">
      <div className="container">
        <div className="row">
          <div className="col-12 col-md-6">
            <div className="head-content">
              <div className="heading-box">
                <h2 className="mb-0">
                  Benefits With <span className="primary-text">Smile24</span>
                </h2>
              </div>
            </div>
            <div className="benift-list">
              <ul>
                  <li>
                    <div className="list-item">
                      <div className="icon-box">
                        <img src="/assets/image/beniftlist01.svg" alt="benefit 1" />
                      </div>
                      <div className="content">
                        <h5>No Cost for Join</h5>
                        <p>Check any pro's work samples, client reviews, and identity verification.</p>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div className="list-item">
                      <div className="icon-box">
                        <img src="/assets/image/beniftlist02.svg" alt="benefit 2" />
                      </div>
                      <div className="content">
                        <h5>Easy post your project</h5>
                        <p>Check any pro's work samples, client reviews, and identity verification.</p>
                      </div>
                    </div>
                  </li>
                  <li>
                    <div className="list-item">
                      <div className="icon-box">
                        <img src="/assets/image/beniftlist03.svg" alt="benefit 3" />
                      </div>
                      <div className="content">
                        <h5>Find A top telents in just a min</h5>
                        <p>Check any pro's work samples, client reviews, and identity verification.</p>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
          <div className="col-12 col-md-6">
            <div className="benift-img-wrapper">
              <img src="/assets/image/beniftimg01.png" className="img-fluid" alt="benefits" />
            </div>
          </div>
          <div className="col-12">
            <p className="text-center mt-4 mt-xl-5">
              Our platform is designed with your needs in mind. Featuring a clear, motivating interface, we guide you
              through every step of creating and managing your profile. With easy-to-navigate sections and engaging
              visual elements, you'll find it simple to highlight your strengths and browse available projects. Our
              tagline, "Find the perfect project connect, apply, and succeed," encapsulates our commitment to making
              your freelancing journey smooth and rewarding. Our platform is designed with your needs in mind.
              Featuring a clear, motivating interface, we guide you through every step of creating and managing your
              profile.
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
