import Link from 'next/link';

interface CtaSectionProps {
  locale: string;
}

export default function CtaSection({ locale }: CtaSectionProps) {
  return (
    <section className="cta-2 py-120">
      <div className="container">
        <div className="cta-center">
          <div className="cta-inner">
            <h3 className="text-white">Find Your Next Hire For A Short Or Long-Term Growth</h3>
            <p className="text-white">Lorem Ipsum is simply dummy text of the printing and typesetting</p>
            <div className="d-flex justify-content-center">
              <Link href={`/${locale}/freelancers`} className="custom-btn white-btn">
                Explore
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
