import Link from 'next/link';
import Image from 'next/image';

interface FreelancersSectionProps {
  locale: string;
}

export default function FreelancersSection({ locale }: FreelancersSectionProps) {
  return (
    <section className="freelancers-wrapper">
      <div className="container">
        <div className="row">
          <div className="col-12 col-md-6 col-xl-5">
            <div className="freelancers-content">
              <div className="heading-box">
                <h2>
                  <span className="primary-text">Smile24</span> For Freelancers
                </h2>
                <p>Stand out. Earn more. Work smarter.</p>
              </div>
              <div className="freelancers-list">
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-1.svg" alt="register" />
                  </div>
                  <div className="content">
                    <h5>Register</h5>
                    <p>Create your Smile24 profile and showcase your skills to get discovered.</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-2.svg" alt="membership" />
                  </div>
                  <div className="content">
                    <h5>Buy Membership</h5>
                    <p>Boost your visibility, stay on top, and access exclusive projects.</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-3.svg" alt="bid" />
                  </div>
                  <div className="content">
                    <h5>Bid & Get Projects</h5>
                    <p>Start bidding with no limits and receive offers from clients across categories.</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-4.svg" alt="earn" />
                  </div>
                  <div className="content">
                    <h5>Earn</h5>
                    <p>Complete projects, build your reputation, and get paid directly from customer — every time.</p>
                  </div>
                </div>
              </div>
              <div className="d-flex mt-40">
                <Link href={`/${locale}/signup`} className="custom-btn primary-fill">
                  Start Earning More
                </Link>
              </div>
            </div>
          </div>
          <div className="col-12 col-md-6 col-xl-7 align-self-end">
            <div className="freelancers-img-wrapper pt-5">
              <img src="/assets/image/freelancers-img.svg" className="img-fluid" alt="freelancers" />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
