import Link from 'next/link';
import Image from 'next/image';

interface PostProjectSectionProps {
  locale: string;
}

export default function PostProjectSection({ locale }: PostProjectSectionProps) {
  return (
    <div className="post-project-wrapper">
      <div className="container">
        <div className="row">
          <div className="col-12 col-md-7">
            <div className="post-content">
              <div className="title">
                <h2>Post Your Project Today</h2>
              </div>
              <p>Lorem Ipsum is simply dummy text of the printing and typesetting</p>
              <div className="d-flex justify-content-start mt-4">
                <Link href={`/${locale}/client/post-project`} className="custom-btn white-btn">
                  Post A Project
                </Link>
              </div>
              <div className="arror-img">
                <img src="/assets/image/arrow.png" alt="arrow" />
              </div>
            </div>
          </div>
          <div className="col-12 col-md-5 align-self-end">
            <div className="img-wrap">
              <img src="/assets/image/post-poject02.png" alt="post project" />
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
