'use client';

import { useEffect, useState } from 'react';

const REMEMBER_ME_KEY = 'smile24_remember_email';

export function useRememberMe() {
  const [rememberedEmail, setRememberedEmail] = useState<string>('');

  useEffect(() => {
    // Load remembered email from localStorage on mount
    const saved = localStorage.getItem(REMEMBER_ME_KEY);
    if (saved) {
      setRememberedEmail(saved);
    }
  }, []);

  const saveEmail = (email: string) => {
    localStorage.setItem(REMEMBER_ME_KEY, email);
    setRememberedEmail(email);
  };

  const clearEmail = () => {
    localStorage.removeItem(REMEMBER_ME_KEY);
    setRememberedEmail('');
  };

  const handleRememberMe = (email: string, remember: boolean) => {
    if (remember) {
      saveEmail(email);
    } else {
      clearEmail();
    }
  };

  return {
    rememberedEmail,
    handleRememberMe,
    clearEmail,
  };
}