# Smile24 - Freelancer Platform

A modern, multi-country freelancer platform built with Next.js 15, TypeScript, Prisma ORM, and MySQL. The platform supports 10 different countries with localized domains, languages, and currencies.

## 🌟 Features

### Multi-Country Support
- **10 Countries**: Luxembourg, Belgium, France, Switzerland, Italy, UK, Portugal, Spain, Germany, Austria
- **Localized Domains**: Each country has its own domain (e.g., smile24.lu, smile24.fr)
- **Multi-Language**: Support for 6 languages (English, French, German, Italian, Portuguese, Spanish)
- **Localized Pricing**: Different package prices per country (€9.90 for most, CHF 19.90 for Switzerland)

### User Types
- **Clients**: Post projects, hire freelancers, manage projects
- **Freelancers**: Bid on projects, showcase skills, earn money
- **Admins**: Manage platform, users, and settings

### Core Functionality
- ✅ User authentication (email + social login)
- ✅ Project posting and management
- ✅ Bidding system
- ✅ Messaging between users
- ✅ Review and rating system
- ✅ Subscription management
- ✅ Payment integration (Stripe + Twint)
- ✅ SEO-friendly pages with server-side rendering
- ✅ Responsive design with Bootstrap 5

## 🚀 Tech Stack

- **Framework**: Next.js 15 with App Router
- **Language**: TypeScript
- **Database**: MySQL with Prisma ORM
- **Authentication**: NextAuth.js
- **Styling**: Bootstrap 5 + Custom CSS
- **Forms**: React Hook Form + Zod validation
- **Payments**: Stripe + Twint (Switzerland)
- **Internationalization**: Built-in Next.js i18n
- **Deployment**: Vercel-ready

## 📋 Prerequisites

- Node.js 18+ 
- MySQL 8.0+
- npm or yarn

## 🛠️ Installation

1. **Clone the repository**
   ```bash
   git clone <repository-url>
   cd smile24-nextjs
   ```

2. **Install dependencies**
   ```bash
   npm install
   ```

3. **Set up environment variables**
   ```bash
   cp .env.example .env.local
   ```
   
   Fill in your environment variables:
   ```env
   # Database
   DATABASE_URL="mysql://user:password@localhost:3306/smile24"
   
   # NextAuth
   NEXTAUTH_URL="http://localhost:3000"
   NEXTAUTH_SECRET="your-secret-key"
   
   # OAuth Providers (optional)
   GOOGLE_CLIENT_ID="your-google-client-id"
   GOOGLE_CLIENT_SECRET="your-google-client-secret"
   FACEBOOK_CLIENT_ID="your-facebook-client-id"
   FACEBOOK_CLIENT_SECRET="your-facebook-client-secret"
   
   # Stripe (for payments)
   STRIPE_PUBLISHABLE_KEY="pk_test_..."
   STRIPE_SECRET_KEY="sk_test_..."
   STRIPE_WEBHOOK_SECRET="whsec_..."
   ```

4. **Set up the database**
   ```bash
   # Generate Prisma client
   npx prisma generate
   
   # Push schema to database
   npx prisma db push
   
   # Seed the database
   npm run db:seed
   ```

5. **Start the development server**
   ```bash
   npm run dev
   ```

6. **Open your browser**
   Navigate to [http://localhost:3000](http://localhost:3000)

## 🗄️ Database Schema

The platform uses a comprehensive database schema with the following main entities:

- **Users**: Authentication and user management
- **Profiles**: Extended user information
- **Countries**: Multi-country configuration
- **Categories**: Service categories (Web Dev, Design, etc.)
- **Projects**: Client project postings
- **Bids**: Freelancer proposals
- **Subscriptions**: Freelancer subscription management
- **Payments**: Payment tracking
- **Messages**: User communication
- **Reviews**: Rating system

## 🌍 Country Configuration

Each country is configured with:
- **Domain**: Country-specific domain
- **Languages**: Supported languages
- **Currency**: Local currency and symbol
- **Package Price**: Subscription pricing
- **Payment Gateways**: Available payment methods

### Example Country Config
```typescript
{
  id: 'luxembourg',
  name: 'Luxembourg',
  code: 'LU',
  domain: 'smile24.lu',
  languages: ['fr', 'en'],
  defaultLanguage: 'fr',
  currency: 'EUR',
  currencySymbol: '€',
  packagePrice: 9.90,
  paymentGateways: ['stripe']
}
```

## 🔐 Authentication

The platform supports multiple authentication methods:
- **Email/Password**: Traditional login
- **Google OAuth**: Social login
- **Facebook OAuth**: Social login

Users are automatically assigned roles (CLIENT, FREELANCER, ADMIN) during registration.

## 💰 Payment Integration

### Stripe Integration
- Subscription management
- Payment processing
- Webhook handling

### Twint Integration (Switzerland)
- Local payment method for Swiss users
- Integrated with Stripe

## 📱 User Flows

### Client Flow
1. Register as a client
2. Post projects with detailed requirements
3. Receive and review bids
4. Select freelancer and award project
5. Manage project progress
6. Leave reviews upon completion

### Freelancer Flow
1. Register as a freelancer
2. Complete profile with skills and portfolio
3. Subscribe to platform (monthly fee)
4. Browse and bid on projects
5. Communicate with clients
6. Complete projects and receive payments

## 🎨 UI/UX Features

- **Responsive Design**: Works on all devices
- **Modern Interface**: Clean, professional design
- **Bootstrap 5**: Consistent styling
- **Loading States**: Smooth user experience
- **Form Validation**: Client and server-side validation
- **Error Handling**: User-friendly error messages

## 🔧 Development

### Available Scripts
```bash
npm run dev          # Start development server
npm run build        # Build for production
npm run start        # Start production server
npm run lint         # Run ESLint
npm run db:push      # Push schema changes
npm run db:seed      # Seed database
npm run db:studio    # Open Prisma Studio
```

### Project Structure
```
src/
├── app/                    # Next.js App Router
│   ├── [locale]/          # Internationalized routes
│   │   ├── (auth)/        # Authentication pages
│   │   ├── (dashboard)/   # User dashboards
│   │   └── (public)/      # Public pages
│   └── api/               # API routes
├── components/            # Reusable components
├── lib/                   # Utilities and configurations
├── types/                 # TypeScript type definitions
└── utils/                 # Helper functions
```

## 🚀 Deployment

### Vercel Deployment
1. Connect your GitHub repository to Vercel
2. Set environment variables in Vercel dashboard
3. Deploy automatically on push to main branch

### Environment Variables for Production
```env
DATABASE_URL="mysql://user:password@host:3306/smile24"
NEXTAUTH_URL="https://your-domain.com"
NEXTAUTH_SECRET="your-production-secret"
STRIPE_PUBLISHABLE_KEY="pk_live_..."
STRIPE_SECRET_KEY="sk_live_..."
```

## 📊 Sample Data

After running the seed script, you'll have:

### Sample Users
- **Admin**: admin@smile24.com / admin123
- **Client**: client@example.com / admin123  
- **Freelancer**: freelancer@example.com / admin123

### Sample Categories
- Web Development
- Mobile Development
- Graphic Design
- Digital Marketing
- Content Writing
- Translation
- Data Entry
- Virtual Assistant

## 🔒 Security Features

- **Input Validation**: Zod schema validation
- **Password Hashing**: bcryptjs for secure passwords
- **CSRF Protection**: Built-in Next.js protection
- **SQL Injection Prevention**: Prisma ORM
- **XSS Protection**: React's built-in protection
- **Rate Limiting**: API route protection

## 📈 Performance

- **Server-Side Rendering**: SEO-friendly public pages
- **Static Generation**: Optimized for performance
- **Image Optimization**: Next.js Image component
- **Code Splitting**: Automatic bundle optimization
- **Caching**: Built-in Next.js caching

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests if applicable
5. Submit a pull request

## 📄 License

This project is proprietary software. All rights reserved.

## 🆘 Support

For support and questions:
- Email: support@smile24.com
- Documentation: [Link to docs]
- Issues: [GitHub Issues]

---

**Built with ❤️ for the European freelancer community**
