import { PrismaClient } from '@prisma/client';
import bcrypt from 'bcryptjs';

const prisma = new PrismaClient();

async function main() {
  console.log('🌱 Starting minimal database seed...');

  // Clear existing data (only tables that exist)
  try {
    await prisma.user.deleteMany();
    console.log('🗑️  Cleared existing user data');
  } catch (error) {
    console.log('⚠️  User table may not exist yet, continuing with seed...');
  }

  // Create a test user
  try {
    const hashedPassword = await bcrypt.hash('password123', 12);
    
    const testUser = await prisma.user.create({
      data: {
        email: 'test@example.com',
        password: hashedPassword,
        emailVerified: new Date(),
        role: 'FREELANCER',
      }
    });

    console.log('👤 Created test user:', testUser.email);
  } catch (error) {
    console.log('⚠️  Could not create test user, user table may not exist yet');
    console.log('This is normal if the database schema is not yet fully migrated');
  }

  console.log('✅ Seed completed successfully');
}

main()
  .catch((e) => {
    console.error('❌ Seed failed:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });