'use client';

import Link from 'next/link';

import { getCountryDataByDomain } from '@/lib/countries';
import { useTranslations } from 'next-intl';
import ScrollToTop from './ui/ScrollToTop';
import { usePathname } from 'next/navigation';

interface FooterProps {
  locale: string;
}

export default function Footer({ locale }: FooterProps) {

  const datacounter =    getCountryDataByDomain();
  const t = useTranslations();
   const pathname = usePathname();
  const langSelected = pathname.split('/')[1] || '';

  return (
    <footer className="footer-wrapper">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="footer-head">
              <div className="footer-logo">
                <a href="home.html">
                  <img src="/assets/image/logo.png" alt="logo" />
                </a>
              </div>
              <div className="footer-land d-flex">
                <div className="language-selector">
                  <div className="nav-item dropdown language-dropdown">                   
                    <a href="javascript:void();" className="nav-link select-lang">
                      <img src={`/assets/image/${langSelected}.svg`} alt="English" className="me-2" />
                              {langSelected?langSelected.toUpperCase():''}                             
                    </a>
                    <ul>

                      {datacounter?.id == "switzerland" && 
                      (
                        <>
                         <li>
                          <a className={langSelected == "fr"? "active" : ''} href="/fr">
                            <img src="/assets/image/fr.svg" alt="French" className="me-2" />French
                          </a>
                        </li>
                         <li>
                        <a className={langSelected == "de"? "active" : ''} href="/de">
                          <img src="/assets/image/de.svg" alt="Germany" className="me-2" />Germany
                        </a>
                       </li>
                        <li>
                          <a className={langSelected == "it"? "active" : ''} href="/it">
                            <img src="/assets/image/it.svg" alt="Italian" className="me-2" />Italian
                          </a>
                        </li>
                        </>
                      )}

                      {datacounter?.id == "france" && 
                      (
                        <>
                         <li>
                          <a className={langSelected == "fr"? "active" : ''} href="/fr">
                            <img src="/assets/image/fr.svg" alt="French" className="me-2" />French
                          </a>
                        </li>
                        <li>
                          <a className={langSelected == "en"? "active" : ''} href="/en">
                            <img src="/assets/image/en.svg" alt="English" className="me-2" />English
                          </a>
                        </li>
                        
                        </>
                      )}

                      {datacounter?.id == "uk" && 
                      (
                        <>
                        <li>
                          <a className={langSelected == "en"? "active" : ''} href="/en">
                            <img src="/assets/image/en.svg" alt="English" className="me-2" />English
                          </a>
                        </li>
                        </>
                      )                      
                      }

                      {/* <li>
                        <a className="active" href="javascript:void();">
                          <img src="/assets/image/eng.svg" alt="English" className="me-2" />English
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/italian.svg" alt="Italian" className="me-2" />Italian
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/french.svg" alt="French" className="me-2" />French
                        </a>
                      </li>
                      <li>
                        <a className="" href="javascript:void();">
                          <img src="/assets/image/germany.svg" alt="German" className="me-2" />German
                        </a>
                      </li> */}

                    </ul>

                  </div>
                </div>
                <div className="footer-socail">
                  <ul>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/f-facebook.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/f-google.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/twitter.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/linkdin.svg" alt="" />
                      </a>
                    </li>
                    <li>
                      <a href="javascript:void(0)">
                        <img src="/assets/image/instagram.svg" alt="" />
                      </a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-12 col-md-4">
            <div className="footer-content">
              <p>
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley
              </p>
            </div>
          </div>
          <div className="col-12 col-md-8">
            <div className="footer-linking mt-4 mt-md-0">
              <div className="row row-gap-3">
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      {t("footer.recruiter.title")}
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href="javascript:void(0)">
                          {t("footer.recruiter.getting_started")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/how-it-works`}>
                          {t("footer.recruiter.how_it_works")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/categories`}>
                          {t("footer.recruiter.categories")}
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      {t("footer.about.title")}
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href={`/${locale}/about-us`}>
                          {t("footer.about.about_us")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/contact-us`}>
                          {t("footer.about.contact_us")}
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      {t("footer.freelancer.title")}
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href={`/${locale}/projects`}>
                          {t("footer.freelancer.projects")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/freelancers`}>
                          {t("footer.freelancer.freelancers")}
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-lg-3">
                  <div className="footer-title">
                    <h5>
                      {t("footer.terms.title")}
                    </h5>
                  </div>
                  <div className="footer-link">
                    <ul>
                      <li>
                        <a href={`/${locale}/privacy-policy`}>
                          {t("footer.terms.privacy_policy")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/terms-condition`}>
                          {t("footer.terms.terms_and_conditions")}
                        </a>
                      </li>
                      <li>
                        <a href={`/${locale}/faq`}>
                          {t("footer.terms.faq")}
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="footer-copy-right">
        <p>
          {t("footer.rights")}
        </p>
      </div>

      <ScrollToTop />
    </footer>
  );
}
