'use client';

import { useState, useRef, useEffect } from 'react';
import NotificationBell from './NotificationBell';
import NotificationList from './NotificationList';

export default function NotificationPanel() {
  const [isOpen, setIsOpen] = useState(false);
  const panelRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const handleClickOutside = (event: MouseEvent) => {
      if (panelRef.current && !panelRef.current.contains(event.target as Node)) {
        setIsOpen(false);
      }
    };

    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  const handleNotificationClick = () => {
    setIsOpen(prev => !prev);
  };

  const handleClose = () => {
    setIsOpen(false);
  };

  return (
    <div className="position-relative notification-wrap notification-panel-wrap" ref={panelRef}>
      <NotificationBell onNotificationClick={handleNotificationClick} />
      {isOpen && <NotificationList onClose={handleClose} />}
    </div>
  );
}