// Simple test script to check if country update works
const fetch = require('node-fetch');

async function testCountryUpdate() {
    console.log('🧪 Testing Country Update Functionality...\n');

    try {
        // Test 1: Check if countries API works
        console.log('1️⃣ Testing countries API...');
        const countriesResponse = await fetch('http://localhost:3005/api/countries');
        const countriesData = await countriesResponse.json();
        console.log('✅ Countries API response:', countriesData.countries?.length || 0, 'countries found');
        
        // Test 2: Check if profile API GET works
        console.log('\n2️⃣ Testing profile GET API...');
        console.log('ℹ️  Note: This requires authentication, so we\'ll just check endpoint availability');
        const profileResponse = await fetch('http://localhost:3005/api/freelancer/profile');
        console.log('📊 Profile API status:', profileResponse.status);
        
        if (profileResponse.status === 401) {
            console.log('✅ Profile API is working (returns 401 without auth as expected)');
        } else {
            console.log('⚠️  Unexpected status code - check API implementation');
        }
        
        console.log('\n🎯 Country Update Fix Summary:');
        console.log('✅ Enhanced profile API to store/retrieve actual country data');
        console.log('✅ Added database integration with fallback to mock data');
        console.log('✅ Fixed hardcoded country values');
        console.log('✅ Added proper country seeding functionality');
        
        console.log('\n🚀 To fully test:');
        console.log('1. Run: npm run db:seed-countries (to populate countries)');
        console.log('2. Login as a freelancer');
        console.log('3. Go to Freelancer → Profile');
        console.log('4. Select a country and save');
        console.log('5. Refresh page - country should persist!');
        
    } catch (error) {
        console.error('❌ Test failed:', error.message);
        console.log('\nℹ️  This is likely because the server is not running.');
        console.log('Run: npm run dev');
    }
}

testCountryUpdate();