'use client';

import { useSession, signOut } from 'next-auth/react';
import { useRememberMe } from '@/hooks/useRememberMe';

interface RememberMeStatusProps {
  locale: string;
}

export default function RememberMeStatus({ locale }: RememberMeStatusProps) {
  const { data: session } = useSession();
  const { clearEmail } = useRememberMe();

  const handleSignOut = async () => {
    // Clear remembered email when user explicitly logs out
    clearEmail();
    await signOut({ callbackUrl: `/${locale}` });
  };

  if (!session?.user) {
    return null;
  }

  const isRemembered = (session.user as any)?.remember;

  return (
    <div className="remember-status d-flex align-items-center">
      {isRemembered && (
        <small className="text-muted me-2" title="You will stay logged in for 30 days">
          <i className="bi bi-clock"></i> Long session
        </small>
      )}
      <button 
        type="button" 
        onClick={handleSignOut} 
        className="dropdown-item"
        title={isRemembered ? "Sign out and clear remembered login" : "Sign out"}
      >
        <img 
          src="/assets/image/logout.svg" 
          alt="Logout" 
          width="16" 
          height="16"
          className="me-2"
        />
        Logout
      </button>
    </div>
  );
}