import NextAuth, { DefaultSession } from "next-auth"
import { JWT } from "next-auth/jwt"

declare module "next-auth" {
  /**
   * Returned by `useSession`, `getSession` and received as a prop on the `SessionProvider` React Context
   */
  interface Session {
    user: {
      /** The user's unique identifier */
      id: string
      /** The user's role */
      role: string
      /** OAuth provider used for authentication */
      provider?: string
      /** Whether remember me was selected */
      remember?: boolean
    } & DefaultSession["user"]
  }

  interface User {
    /** The user's unique identifier */
    id: string
    /** The user's role */
    role: string
    /** Whether remember me was selected */
    remember?: boolean
  }
}

declare module "next-auth/jwt" {
  /** Returned by the `jwt` callback and `getToken`, when using JWT sessions */
  interface JWT {
    /** The user's unique identifier */
    id: string
    /** The user's role */
    role: string
    /** OAuth provider used for authentication */
    provider?: string
    /** Whether remember me was selected */
    remember?: boolean
  }
}