export interface ProjectDocument {
  id: string;
  name: string;
  originalName: string;
  size: string;
  type: string;
  url: string;
  uploadedBy: string;
  createdAt: string;
}

export interface ProjectDetails {
  id: string;
  title: string;
  description: string;
  status: 'active' | 'ongoing' | 'completed' | 'cancelled' | 'draft';
  budget: number;
  currency: string;
  deadline: string;
  duration: number;
  createdAt: string;
  startedAt: string | null;
  completedAt: string | null;
  cancelledAt: string | null;
  freelancerId: string | null;
  clientId: string;
  freelancerName: string;
  freelancerAvatar?: string;
  freelancerRating?: number;
  freelancerReviewsCount?: number;
  clientName: string;
  clientAvatar: string;
  clientRating: number;
  clientReviewsCount: number;
  clientProjectsCount: number;
  clientMemberSince: string;
  clientLocation: string;
  category: string;
  categoryIcon: string;
  userRole: 'freelancer' | 'client';
  progress: number;
  documents: ProjectDocument[];
  currentMilestone: string | null;
  bidAmount?: number;
  bidStatus?: string;
  bidsCount?: number;
  // User bid information
  hasUserBid?: boolean;
  userBidStatus?: string | null;
  userBidAmount?: number | null;
  userBidId?: string | null;
  userBidDuration?: number | null;
}

export interface SimilarProject {
  id: string;
  title: string;
  description: string;
  budget: number;
  currency: string;
  category: string;
  categoryIcon: string;
  clientName: string;
  clientAvatar: string;
  clientRating: number;
  clientReviewsCount: number;
  bidsCount: number;
  duration: number;
  status: string;
}

export interface ApiResponse<T> {
  success: boolean;
  data: T;
  error?: string;
  type?: string;
}