// next.config.ts
import type { NextConfig } from "next";
import createNextIntlPlugin from "next-intl/plugin";

// Initialize the next-intl plugin (you can also specify your i18n request file like "./src/i18n/request.ts")
const withNextIntl = createNextIntlPlugin();

const nextConfig: NextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  typescript: {
    ignoreBuildErrors: true,
  },
  images: {
    remotePatterns: [],
    unoptimized: true, // For SVG files
  },
  // Enable static exports for better performance
  output: "standalone",
};

export default withNextIntl(nextConfig);
