'use client';

import Link from 'next/link';
import ErrorState from '@/components/ui/ErrorState';

export default function NotFound() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-50">
      <div className="max-w-md w-full">
        <ErrorState 
          title="Page Not Found"
          description="The page you're looking for doesn't exist or has been moved."
          errorCode="404"
        />
        <div className="text-center mt-6">
          <Link 
            href="/"
            className="inline-block px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"
          >
            Go Back Home
          </Link>
        </div>
      </div>
    </div>
  );
}