"use client"
import Link from 'next/link';
import Image from 'next/image';
import { useTranslations } from 'next-intl';

interface FreelancersSectionProps {
  locale: string;
}

export default function FreelancersSection({ locale }: FreelancersSectionProps) {
  const t = useTranslations();
  return (
    <section className="freelancers-wrapper">
      <div className="container">
        <div className="row">
          <div className="col-12 col-md-6 col-xl-5">
            <div className="freelancers-content">
              <div className="heading-box">
                <h2>
                  <span className="primary-text">{t("home.name")}</span> {t("home.freelancers.for_freelancer")}
                </h2>
                <p>{t("home.freelancers.title")}</p>
              </div>
              <div className="freelancers-list">
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-1.svg" alt="register" />
                  </div>
                  <div className="content">
                    <h5>{t("home.freelancers.steps.first.title")}</h5>
                    <p>{t("home.freelancers.steps.first.description")}</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-2.svg" alt="membership" />
                  </div>
                  <div className="content">
                    <h5>{t("home.freelancers.steps.second.title")}</h5>
                    <p>{t("home.freelancers.steps.second.description")}</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-3.svg" alt="bid" />
                  </div>
                  <div className="content">
                    <h5>{t("home.freelancers.steps.third.title")}</h5>
                    <p>{t("home.freelancers.steps.third.description")}</p>
                  </div>
                </div>
                <div className="list-item">
                  <div className="icon-box">
                    <img src="/assets/image/freelancers-4.svg" alt="earn" />
                  </div>
                  <div className="content">
                    <h5>{t("home.freelancers.steps.fourth.title")}</h5>
                    <p>{t("home.freelancers.steps.fourth.description")}</p>
                  </div>
                </div>
              </div>
              <div className="d-flex mt-40">
                <Link href={`/${locale}/signup`} className="custom-btn primary-fill">
                  {t("home.freelancers.earn_more")}
                </Link>
              </div>
            </div>
          </div>
          <div className="col-12 col-md-6 col-xl-7 align-self-end">
            <div className="freelancers-img-wrapper pt-5">
              <img src="/assets/image/freelancers-img.svg" className="img-fluid" alt="freelancers" />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
