import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function seedSubscriptions() {
  try {
    // Get first freelancer and categories for demo
    const freelancer = await prisma.user.findFirst({
      where: { role: 'FREELANCER' }
    });

    const categories = await prisma.category.findMany({
      take: 3 // Get first 3 categories
    });

    if (!freelancer || categories.length === 0) {
      console.log('No freelancer or categories found. Run main seed first.');
      return;
    }

    console.log(`Creating subscriptions for freelancer: ${freelancer.email}`);

    // Create active subscriptions for the freelancer
    for (const category of categories) {
      const existingSubscription = await prisma.categorySubscription.findFirst({
        where: {
          userId: freelancer.id,
          categoryId: category.id,
          status: 'ACTIVE'
        }
      });

      if (!existingSubscription) {
        await prisma.categorySubscription.create({
          data: {
            userId: freelancer.id,
            categoryId: category.id,
            status: 'ACTIVE',
            startDate: new Date(),
            endDate: new Date(Date.now() + 30 * 24 * 60 * 60 * 1000) // 30 days from now
          }
        });

        console.log(`✓ Created subscription for category: ${category.name}`);
      } else {
        console.log(`✓ Subscription already exists for category: ${category.name}`);
      }
    }

    console.log('Subscription seeding completed!');
  } catch (error) {
    console.error('Error seeding subscriptions:', error);
  } finally {
    await prisma.$disconnect();
  }
}

seedSubscriptions();