// Run this script to seed sample reviews in the database
// Usage: node scripts/seed-reviews.js

const { exec } = require('child_process');
const path = require('path');

console.log('🚀 Starting review seeding...');

// Run the TypeScript seeder
exec('npx tsx prisma/seed-reviews.ts', (error, stdout, stderr) => {
  if (error) {
    console.error(`❌ Error executing seeder: ${error}`);
    return;
  }
  if (stderr) {
    console.error(`⚠️  Warning: ${stderr}`);
  }
  console.log(stdout);
  console.log('✅ Review seeding completed!');
});