import { NextRequest, NextResponse } from 'next/server';
import { getServerSession } from 'next-auth';
import { authOptions } from '@/lib/auth';

export async function GET(req: NextRequest) {
  try {
    console.log('[Session Diagnostic] Headers:', Object.fromEntries(req.headers.entries()));
    console.log('[Session Diagnostic] Cookies:', req.cookies.getAll());
    
    const session = await getServerSession(authOptions);
    
    return NextResponse.json({
      success: true,
      data: {
        hasSession: !!session,
        session: session ? {
          user: {
            id: (session.user as any)?.id,
            email: session.user?.email,
            name: session.user?.name,
            role: (session.user as any)?.role
          },
          expires: session.expires
        } : null,
        cookies: req.cookies.getAll(),
        timestamp: new Date().toISOString()
      }
    });
  } catch (error) {
    console.error('[Session Diagnostic] Error:', error);
    return NextResponse.json({
      success: false,
      error: error instanceof Error ? error.message : 'Unknown error',
      stack: error instanceof Error ? error.stack : undefined
    });
  }
}