"use client"
import { useTranslations } from 'next-intl';
import { getTranslations } from 'next-intl/server';
import Link from 'next/link';

interface CtaSectionProps {
  locale: string;
}

export default function CtaSection({ locale }: CtaSectionProps) {
  const t = useTranslations();
  return (
    <section className="cta-2 py-120">
      <div className="container">
        <div className="cta-center">
          <div className="cta-inner">
            <h3 className="text-white">{t("home.cta.title")}</h3>
            <p className="text-white">{t("home.cta.description")}</p>
            <div className="d-flex justify-content-center">
              <Link href={`/${locale}/freelancers`} className="custom-btn white-btn">
                {t("home.cta.explore")}
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
