"use client";
import React from "react";
import Link from "next/link";
import { getCountryDataByDomain } from "@/lib/countries";
import { useTranslations } from "next-intl";

const HomeBanner = ({ locale }: any) => {
  const datacounter = getCountryDataByDomain();
  const t = useTranslations();

  return (
    <>
      <section className="hero-wrapper position-relative pt-80">
        <div className="bg-shap position-absolute bottom-0 start-0 z-3 w-100">
          <img src="/assets/image/banner-shap.svg" alt="shap" />
        </div>
        <div className="container z-2">
          <div className="row">
            <div className="col-12 col-md-12">
              <div className="hero-content">
                <h1>
                  <span className="primary-color">
                    {t("home.post_project")}
                  </span>{" "}
                  {t("home.banner.for_free")}{" "}
                  <span className="secondary-text">
                    {t("home.banner.talent")}
                  </span>{" "}
                  {t("home.banner.in_min")}
                </h1>
                <p>{t("home.banner.description")}</p>
                <div className="button-group justify-content-center">
                  <Link
                    href={`/${locale}/client/post-project`}
                    className="custom-btn primary-fill rounded-pill btn-lg"
                  >
                    {t("home.post_project")}
                  </Link>
                  <Link
                    href={`/${locale}/freelancers`}
                    className="custom-btn secondary-outline rounded-pill btn-lg"
                  >
                    {t("home.hire_freelancer")}
                  </Link>
                </div>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-12 col-md-12">
              <div className="w-100 position-relative hero-image-outer">
                <div className="animi-card an-1">
                  <img
                    src="/assets/image/home/proofilecard3.svg"
                    alt="proofilecard1"
                  />
                  <div className="animi-chat02 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_one")} <br />
                        {t("home.post_banner_two")} {datacounter?.currencySymbol} 50....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="animi-card an-2">
                  <img
                    src="/assets/image/home/proofilecard1.svg"
                    alt="proofilecard2"
                  />
                  <div className="animi-chat03 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_five")}
                        <br />
                        {t("home.post_banner_for")} {datacounter?.currencySymbol} 10....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="animi-card an-3">
                  <img
                    src="/assets/image/home/proofilecard2.svg"
                    alt="proofilecard3"
                  />
                  <div className="animi-chat03 animi-chat">
                    <div className="content">
                      <h5>
                        {t("home.post_banner_five")}
                        <br />
                        {t("home.post_banner_for")} {datacounter?.currencySymbol} 10....
                        <span>3 {t("home.post_banner_three")}</span>
                      </h5>
                    </div>
                  </div>
                </div>
                <div className="hero-image">
                  <div className="user-img">
                    <img
                      src="/assets/image/heroimg01.svg"
                      className="img-fluid"
                      alt=""
                    />
                  </div>
                  <div className="animi-icon icon-1">
                    <img src="/assets/image/home/plan-1.svg" alt="plan-1.svg" />
                  </div>
                  <div className="animi-icon icon-2">
                    <img src="/assets/image/home/plan-2.svg" alt="plan-2.svg" />
                  </div>
                  <div className="animi-icon icon-3">
                    <img src="/assets/image/home/plan-3.svg" alt="plan-3.svg" />
                  </div>
                  <div className="animi-chat01 animi-chat aniamtion-key-1">
                    <div className="icon">
                      <img src="/assets/image/animichat03.png" alt="" />
                    </div>
                    <div className="content">
                      <h5>{t("home.post_project")} </h5>
                      <span>5 {t("home.post_banner_three")}</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default HomeBanner;
