'use client';

import Image from 'next/image';

interface ErrorStateProps {
  title: string;
  description?: string;
  errorCode?: string;
  image?: string;
  onRetry?: () => void;
  className?: string;
}

export default function ErrorState({ 
  title, 
  description, 
  errorCode,
  image = '/assets/image/error-state.svg',
  onRetry,
  className = '' 
}: ErrorStateProps) {
  return (
    <div className={`error-state text-center py-8 ${className}`}>
      <div className="error-state-image mb-4">
        <Image
          src={image}
          alt="Error state"
          width={120}
          height={120}
          className="mx-auto opacity-60"
        />
      </div>
      
      {errorCode && (
        <div className="error-code text-sm font-mono text-gray-400 mb-2">
          Error: {errorCode}
        </div>
      )}
      
      <h3 className="error-state-title text-lg font-semibold text-red-600 mb-2">
        {title}
      </h3>
      
      {description && (
        <p className="error-state-description text-gray-600 mb-4 max-w-sm mx-auto">
          {description}
        </p>
      )}
      
      {onRetry && (
        <div className="error-state-action">
          <button 
            onClick={onRetry}
            className="btn btn-outline px-6 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50 transition-colors"
          >
            Try Again
          </button>
        </div>
      )}
    </div>
  );
}