const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

const categories = [
  { name: 'Agriculture', icon: 'Agriculture.svg' },
  { name: 'Jewelry', icon: 'Jewelry.svg' },
  { name: 'Bakery-Patisserie', icon: 'Bakery-Patisserie.svg' },
  { name: 'Tile', icon: 'Tile.svg' },
  { name: 'Bodywork', icon: 'Bodywork.svg' },
  { name: 'Ceramic', icon: 'Ceramic.svg' },
  { name: 'Carpentry', icon: 'Carpentry.svg' },
  { name: 'Heating', icon: 'Heating.svg' },
  { name: 'Metal construction', icon: 'Metal-Construction.svg' },
  { name: 'Coronaries', icon: 'Coronaries.svg' },
  { name: 'Cuisine', icon: 'Cuisine.svg' },
  { name: 'Cabinetmaking / Carpentry', icon: 'Cabinetmaking-Carpentry.svg' },
  { name: 'Scaffolding', icon: 'Scaffolding.svg' },
  { name: 'Electrical', icon: 'Electrical.svg' },
  { name: 'Electronics', icon: 'Electronics.svg' },
  { name: 'Forging', icon: 'Forging.svg' },
  { name: 'Tightness', icon: 'Tightness.svg' },
  { name: 'Forest and Garden', icon: 'Forest-and-Garden.svg' },
  { name: 'Graphics', icon: 'Graphics.svg' },
  { name: 'Watchmaking', icon: 'Watchmaking.svg' },
  { name: 'Freemasonry', icon: 'Freemasonry.svg' },
  { name: 'Auto Mechanic', icon: 'Auto-Mechanic.svg' },
  { name: 'Motorcycle Mechanics', icon: 'Motorcycle-Mechanics.svg' },
  { name: 'Paint', icon: 'Paint.svg' },
  { name: 'Goldsmith', icon: 'Goldsmith.svg' },
  { name: 'Plastering', icon: 'Plastering.svg' },
  { name: 'Ramonage', icon: 'Ramonage.svg' },
  { name: 'Director/publicity trick', icon: 'Director-Publicity-trick.svg' },
  { name: 'Sanitary', icon: 'Sanitary.svg' },
  { name: 'Sculpture', icon: 'Sculpture.svg' },
  { name: 'Care', icon: 'Care.svg' },
  { name: 'solar', icon: 'solar.svg' },
  { name: 'Tapestry', icon: 'Tapestry.svg' },
  { name: 'Transports', icon: 'Transports.svg' },
  { name: 'Ventilation', icon: 'Ventilation.svg' }
];

async function main() {
  for (const category of categories) {
    const slug = category.name.toLowerCase().replace(/ /g, '-').replace(/\//g, '-');
    await prisma.category.upsert({
      where: { slug },
      update: { icon: category.icon },
      create: {
        name: category.name,
        slug,
        icon: category.icon,
        isActive: true
      }
    });
  }
}

main()
  .catch(e => {
    console.error(e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
